// dark-mode.js

export function setupDarkModeToggle() {
  const toggle = document.createElement('button');
  toggle.textContent = '🌓';
  toggle.className = 'dark-toggle';
  toggle.style.position = 'fixed';
  toggle.style.bottom = '20px';
  toggle.style.right = '20px';
  toggle.style.padding = '10px';
  toggle.style.fontSize = '20px';
  toggle.style.borderRadius = '50%';
  toggle.style.border = 'none';
  toggle.style.background = '#333';
  toggle.style.color = '#fff';
  toggle.style.cursor = 'pointer';
  toggle.style.zIndex = '9999';

  toggle.onclick = () => {
    document.body.classList.toggle('dark-mode');
    localStorage.setItem('theme', document.body.classList.contains('dark-mode') ? 'dark' : 'light');
  };

  document.body.appendChild(toggle);

  const saved = localStorage.getItem('theme');
  if (saved === 'dark') {
    document.body.classList.add('dark-mode');
  }
}

window.addEventListener('DOMContentLoaded', () => {
  setupDarkModeToggle();
});
